module axis_s
#( parameter
    SIZE_S          = 3'b010        // always refer to DATW_S
,   DATW_ST         =  64
,   KEPW_ST         = (DATW_ST/8)   // always refer to DATW_ST
,   STBW_S          = (DATW_ST/8)
,   DTMP            =  4096
,   STMP            =  DTMP/KEPW_ST   
)
(
    input                       S_AXI_ACLK
,   input                       S_AXI_ARESETN

    // AXI Stream Slave : s_axis
,   input  [       DATW_ST-1:0] s_axis_tdata
,   input  [       KEPW_ST-1:0] s_axis_tkeep
,   input                       s_axis_tlast
,   input                       s_axis_tvalid
,   output reg                  s_axis_tready

    //==================================
    // Unused Signals
    //==================================
);

    import "DPI-C" function void    C_send_packet(input int id, input int len, input byte data_tmp[DTMP]);
    
    //---------------------------------------------------------------------
    // Constant Declarations
    //---------------------------------------------------------------------

    localparam IDLE = 0;
    localparam DATA = 1;

    //---------------------------------------------------------------------
    // Reg/Wire
    //---------------------------------------------------------------------

    reg        [           1:0] r_state                 , n_state                   ;
    reg        [         8-1:0] r_len                   , n_len                     ;
    byte                        r_data_tmp [0:DTMP-1]   , n_data_tmp [0:DTMP-1]     ;
    integer                     r_size                  , n_size                    ;
    reg        [           1:0] send_pkt;

    //---------------------------------------------------------------------
    // Instance
    //---------------------------------------------------------------------

    //---------------------------------------------------------------------
    // Main
    //---------------------------------------------------------------------

    //------------------------------------------------------
    // Combo
    //------------------------------------------------------

    integer i, j;

    always@(*)
    begin: COMBO_SEND
        automatic logic [KEPW_ST-1:0] tkeep = s_axis_tkeep;
        
        n_state    = r_state    ;
        n_len      = r_len      ;
        n_data_tmp = r_data_tmp ;
        n_size     = r_size     ;
        send_pkt   = 2'b0       ;
        
        if ( r_state == IDLE ) begin
            n_len  = 0;
            n_size = 0;
        end
        
        if(s_axis_tvalid && tkeep ) begin
            n_state = DATA;
            i = 0;
            j = 0;
            while ( tkeep ) begin
                if ( tkeep & 1 ) begin
                    n_data_tmp[(r_len*KEPW_ST)+i] = s_axis_tdata[(j*8)+:8];
                    i = i + 1;
                    n_size = n_size + 1;
                end
                j = j + 1;
                tkeep >>= 1;
            end
            if ( !s_axis_tlast ) begin
                n_len = r_len + 1;
            end else begin
                n_state  = IDLE  ;
                send_pkt = 2'b01 ;
            end
        end
    end // COMBO_SEND
    
    //------------------------------------------------------
    // FF
    //------------------------------------------------------

    always@(posedge S_AXI_ACLK)
    begin: DPI
        if (send_pkt) begin
            C_send_packet(0, n_size, n_data_tmp);
        end
    end // DISPLAY AND DPI

    always@(posedge S_AXI_ACLK)
    begin: FF_SEND
        if(~S_AXI_ARESETN) begin
            r_state    <= IDLE       ;
            r_len      <= 0          ;
            r_size     <= 0          ;
        end
        else begin
            r_state    <= n_state    ;
            r_len      <= n_len      ;
            r_size     <= n_size     ;
            r_data_tmp <= n_data_tmp ;
        end
    end // FF_SEND
    
    //---------------------------------------------------------------------
    // Primary Output Assignment
    //---------------------------------------------------------------------

    // Combo Out
    // Const Out
    assign s_axis_tready = 1;
    // Reg   Out
endmodule
